require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/foodworktable.zip"),
	Asset("ATLAS", "images/inventoryimages/foodworktable.xml")
}

local prefabs =
{
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("goldnugget").Transform:SetPosition(x, y, z)
	SpawnPrefab("boards").Transform:SetPosition(x, y, z)
    
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle", true)
end
--容器格子
local slotpos = {    Vector3(0,64+32+8+4,0), --this table has the four slots' positions in form of Vector3(x,y,z)
                    Vector3(0,32+4,0),
                    Vector3(0,-(32+4),0),
                    Vector3(0,-(64+32+8+4),0)}
--按钮
local widgetbuttoninfo = { --the cook button (optional)
    text = "加工",
    position = Vector3(0, -165, 0),
    fn = function(inst) --when clicked
        inst.components.stewer:StartCooking()    
    end,

    validfn = function(inst) --can it be clicked?
        return inst.components.stewer:CanCook()
    end,
}
--
local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end
--打开关闭
local function onopen(inst) --some fancy stuff
inst.AnimState:PlayAnimation("idle")
end

local function onclose(inst) --more fancy stuff
inst.AnimState:PlayAnimation("idle")
end


local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
    inst.AnimState:PlayAnimation("hit")
end
local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .4)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 2,2 )
    inst.AnimState:SetBank("foodworktable")
    inst.AnimState:SetBuild("foodworktable")
    inst.AnimState:PlayAnimation("idle")
    MakeSnowCoveredPristine(inst)
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	--分界线
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
    inst:AddComponent("lootdropper")
	inst:ListenForEvent("onbuilt", onbuilt)
	--预制物容器
	inst:AddComponent("container")
	inst.components.container:WidgetSetup("foodworktable")
    inst.components.container.onopenfn = onopen --for that fancy stuff
    inst.components.container.onclosefn = onclose   
	--容器结束
	   
	MakeHauntableWork(inst)
    return inst
end
return Prefab("foodworktable", fn, assets, prefabs),
    MakePlacer("foodworktable_placer", "foodworktable", "foodworktable", "idle")
